package structure.location;

import java.util.ArrayList;
import java.util.List;

import structure.device.Heater;
import structure.device.Light;
import structure.device.Shutter;

public abstract class CompositeLocation extends Location {
	abstract List<? extends Location> locations();

	public List<Shutter> shutters() {
		List<Shutter> shutters = new ArrayList<Shutter>();
		for (Location child : locations()) {
			shutters.addAll(child.shutters());
		}
		return shutters;
	}

	public List<Light> lights() {
		List<Light> lights = new ArrayList<Light>();
		for (Location child : locations()) {
			lights.addAll(child.lights());
		}
		return lights;
	}

	public List<Heater> heaters() {
		List<Heater> heaters = new ArrayList<Heater>();
		for (Location child : locations()) {
			heaters.addAll(child.heaters());
		}
		return heaters;
	}
}
